float3 lightPos;
float3 viewPos;
float4 mtrlAmbient;
float4 mtrlDiffuse;
float4 mtrlSpecular;

float focalDist;
float focalRange;

float globalLight;

matrix matWorldViewProj;

texture tTexture;

///////////////////////////////////////////////////////////////////////////////

struct VS_INPUT
{
	float4 vPosition: POSITION;
	float3 vNormal: NORMAL;
	float2 vTexCoord: TEXCOORD0;
};

struct VS_OUTPUT_NOTEX
{
	float4 vPosition: POSITION;
	float fDepth: TEXCOORD0;
	float3 vNormal: TEXCOORD1;
	float3 vL: TEXCOORD2;
	float3 vH: TEXCOORD3;
};

struct VS_OUTPUT_TEX
{
	float4 vPosition: POSITION;
	float fDepth: TEXCOORD0;
	float3 vNormal: TEXCOORD1;
	float3 vL: TEXCOORD2;
	float3 vH: TEXCOORD3;
	float2 vTexCoord: TEXCOORD4;
};

///////////////////////////////////////////////////////////////////////////////

struct PS_INPUT_NOTEX
{
	float4 vColor: COLOR0;
	float fDepth: TEXCOORD0;
	float3 vNormal: TEXCOORD1;
	float3 vL: TEXCOORD2;
	float3 vH: TEXCOORD3;
};

struct PS_INPUT_TEX
{
	float4 vColor: COLOR0;
	float fDepth: TEXCOORD0;
	float3 vNormal: TEXCOORD1;
	float3 vL: TEXCOORD2;
	float3 vH: TEXCOORD3;
	float2 vTexCoord: TEXCOORD4;
};

struct PS_OUTPUT
{
	float4 vColor: COLOR0;
	float4 vDoF: COLOR1;
};

///////////////////////////////////////////////////////////////////////////////

// Simple non-textures object vertex shader
VS_OUTPUT_NOTEX obj_no_tex_vs(VS_INPUT v)
{
	VS_OUTPUT_NOTEX o;
	float4 vPosWVP;
	vPosWVP = mul(v.vPosition, matWorldViewProj);
	o.vPosition = vPosWVP;
	o.fDepth = vPosWVP.z;

	o.vNormal = v.vNormal;
	o.vL = normalize(lightPos - v.vPosition);
	// Compute halfway vector
	o.vH = normalize(normalize(viewPos - v.vPosition) + o.vL);
	return o;
}

// Non-textured object pixel shader
PS_OUTPUT obj_no_tex_ps(PS_INPUT_NOTEX v)
{
	PS_OUTPUT o;

	float specularExp = 70.0f;
	float4 lightDiffuse = float4(0.5f, 0.5f, 0.5f, 1.0f);

	float3 vN = normalize(v.vNormal);
	float3 vL = normalize(v.vL);
	float3 vH = normalize(v.vH);

	// Compute color
//	o.vColor = dot(vN, vL) * mtrlDiffuse * lightDiffuse + pow(dot(vN, vH), specularExp) * mtrlSpecular + mtrlAmbient;
o.vColor = dot(vN, vL) * mtrlDiffuse * lightDiffuse + pow(dot(vN, vH), specularExp) * mtrlSpecular + mtrlAmbient;

	// Blur factor based on the distance from focal plane
	float blur = saturate(abs(v.fDepth - focalDist) * focalRange);

	// Depth value
	o.vDoF = float4(v.fDepth, blur, 0, 0);

	return o;
}

technique ObjNoTex
{
	pass P0
	{
		VertexShader = compile vs_2_0 obj_no_tex_vs();
		PixelShader  = compile ps_2_0 obj_no_tex_ps();

		CullMode = NONE;
	}
}

///////////////////////////////////////////////////////////////////////////////

// Simple textured object vertex shader
VS_OUTPUT_TEX obj_tex_vs(VS_INPUT v)
{
	VS_OUTPUT_TEX o;
	float4 vPosWVP;

	vPosWVP = mul(v.vPosition, matWorldViewProj);
	o.vPosition = vPosWVP;
	o.fDepth = vPosWVP.z;

	o.vNormal = v.vNormal;
	o.vL = normalize(lightPos - v.vPosition);
	// Compute halfway vector
	o.vH = normalize(normalize(viewPos - v.vPosition) + o.vL);
	o.vTexCoord = v.vTexCoord;

	return o;
}

// Use point sampling for sharp tile edges on the walls
sampler PointTexSampler = sampler_state
{
	Texture = (tTexture);

	MinFilter = Linear;//Point;
	MagFilter = Linear;//Point;
	AddressU = Wrap;
	AddressV = Wrap;
};

// Textured object pixel shader
PS_OUTPUT obj_tex_ps(PS_INPUT_TEX v)
{
	float specularExp = 10.0f;
	float4 lightDiffuse = float4(0.5f, 0.5f, 0.5f, 1.0f);

	PS_OUTPUT o;

	float3 vN = normalize(v.vNormal);
	float3 vL = normalize(v.vL);
	float3 vH = normalize(v.vH);

	// Compute color
	//o.vColor = dot(vN, vL) * tex2D(PointTexSampler, v.vTexCoord) + mtrlAmbient;
	
	o.vColor = dot(vN, vL) * tex2D(PointTexSampler, v.vTexCoord) + pow(dot(vN, vH), specularExp) * mtrlSpecular + mtrlAmbient;

//	o.vColor = dot(vN, vL) * tex2D(PointTexSampler, v.vTexCoord) + pow(dot(vN, vH), specularExp)* tex2D(PointTexSampler, v.vTexCoord)  + mtrlAmbient;


	// Blur factor based on the distance from focal plane
	float blur = saturate(abs(v.fDepth - focalDist) * focalRange);

	// Depth value
	o.vDoF = float4(v.fDepth, blur, 0, 0);

	return o;
}


// Textured object pixel shader
PS_OUTPUT obj_tex_wall_ps(PS_INPUT_TEX v)
{
	float specularExp = 1.f;
	float4 lightDiffuse = float4(0.5f, 0.5f, 0.5f, 1.0f);

	PS_OUTPUT o;

	float3 vN = normalize(v.vNormal);
	float3 vL = normalize(v.vL);
	float3 vH = normalize(v.vH);

	// Compute color
	//o.vColor = dot(vN, vL) * tex2D(PointTexSampler, v.vTexCoord) + mtrlAmbient;
	
//	o.vColor = dot(vN, vL) * tex2D(PointTexSampler, v.vTexCoord) + pow(dot(vN, vH), specularExp) * mtrlSpecular;// + mtrlAmbient;

	//o.vColor = (dot(vN, vL) + pow(dot(vN, vH), specularExp)) * tex2D(PointTexSampler, v.vTexCoord);// + pow(dot(vN, vH), specularExp)* tex2D(PointTexSampler, v.vTexCoord) ;
//o.vColor = (dot(vN, vL) + pow(dot(vN, vH), specularExp)) * tex2D(PointTexSampler, v.vTexCoord);// + pow(dot(vN, vH), specularExp)* tex2D(PointTexSampler, v.vTexCoord) ;

o.vColor =  ( dot(vN, vL) + pow(dot(vN, vH), specularExp) )   * tex2D(PointTexSampler, v.vTexCoord);// + pow(dot(vN, vH), specularExp)* tex2D(PointTexSampler, v.vTexCoord) ;

//o.vColor = globalLight * tex2D(PointTexSampler, v.vTexCoord);

	// Blur factor based on the distance from focal plane
	float blur = saturate(abs(v.fDepth - focalDist) * focalRange);

	// Depth value
	o.vDoF = float4(v.fDepth, blur, 0, 0);

	return o;
}


// Textured object pixel shader
PS_OUTPUT obj_tex_fog_ps(PS_INPUT_TEX v)
{
	//float specularExp = 1.f;
	//float4 lightDiffuse = float4(0.5f, 0.5f, 0.5f, 1.0f);

	PS_OUTPUT o;

	float3 vN = normalize(v.vNormal);
	float3 vL = normalize(v.vL);
	float3 vH = normalize(v.vH);

	// Compute color

	float fLum =  saturate( (48 - v.fDepth) *.016 ); // .022 sans specular

//	o.vColor = ( ( dot(vN, vL) + pow( dot(vN, vH), 10 ) ) * fLum* fLum  ) * tex2D(PointTexSampler, v.vTexCoord);
o.vColor = (( dot(vN, vL) +  dot(vN, vH)  ) * fLum* fLum  ) * tex2D(PointTexSampler, v.vTexCoord);
//o.vColor = (( dot(vN, vL)   ) * fLum* fLum  ) * tex2D(PointTexSampler, v.vTexCoord);
	// Blur factor based on the distance from focal plane
	float blur = saturate(abs(v.fDepth - focalDist) * focalRange);

	// Depth value
	o.vDoF = float4(v.fDepth, blur, 0, 0);

	return o;
}

technique ObjTex
{
	pass P0
	{
		VertexShader = compile vs_2_0 obj_tex_vs();
		PixelShader  = compile ps_2_0 obj_tex_ps();

		CullMode = NONE;
	}
}


technique ObjTexWall
{
	pass P0
	{
		VertexShader = compile vs_2_0 obj_tex_vs();
		PixelShader  = compile ps_2_0 obj_tex_wall_ps();

		CullMode = NONE;
	}
}

technique ObjTexFog
{
	pass P0
	{
		VertexShader = compile vs_2_0 obj_tex_vs();
		PixelShader  = compile ps_2_0 obj_tex_fog_ps();

		CullMode = NONE;
	}
}
///////////////////////////////////////////////////////////////////////////////

// Simple textured object vertex shader
VS_OUTPUT_TEX obj_alpha_tex_vs(VS_INPUT v)
{
	VS_OUTPUT_TEX o;
	float4 vPosWVP;

	vPosWVP = mul(v.vPosition, matWorldViewProj);
	o.vPosition = vPosWVP;
	o.fDepth = vPosWVP.z;

	o.vNormal = v.vNormal;
	o.vL = normalize(lightPos - v.vPosition);
	// Compute halfway vector
	o.vH = normalize(normalize(viewPos - v.vPosition) + o.vL);
	o.vTexCoord = v.vTexCoord;

	return o;
}

// Use point sampling for sharp tile edges on the walls
sampler PointAlphaTexSampler = sampler_state
{
	Texture = (tTexture);

	MinFilter = Linear;//Point;
	MagFilter = Linear;//Point;
	AddressU = Wrap;
	AddressV = Wrap;
};

// Textured object pixel shader
PS_OUTPUT obj_alpha_tex_ps(PS_INPUT_TEX v)
{
	PS_OUTPUT o;

	float3 vN = normalize(v.vNormal);
	float3 vL = normalize(v.vL);
	float3 vH = normalize(v.vH);

	// Compute color
//	float4 text = tex2D( PointAlphaTexSampler, v.vTexCoord);
//	o.vColor = dot(vN, vL) * text + mtrlAmbient;
//	o.vColor.a = text.a;
	
	o.vColor = tex2D( PointAlphaTexSampler, v.vTexCoord);
	// Blur factor based on the distance from focal plane
	float blur = saturate(abs(v.fDepth - focalDist) * focalRange);

	// Depth value	
	o.vDoF = float4(v.fDepth, blur, 0, 0);

	return o;
}

technique ObjAlphaTex
{
	pass P0
	{
		// Alpha blending
        AlphaBlendEnable = true;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        
		VertexShader = compile vs_2_0 obj_alpha_tex_vs();
		PixelShader  = compile ps_2_0 obj_alpha_tex_ps();

		CullMode = NONE;
	}
}
